/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.util;

import com.ibm.hwmca.base.managed.BaseTower;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.util.BinaryNumber;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.Trace;
import java.lang.reflect.UndeclaredThrowableException;

public class SimServer {
    private static final String TRACE_MASKT = "XSIMSERT";
    private static final String TRACE_MASKF = "XSIMSERF";
    private static final String TRACE_MASKD = "XSIMSERD";
    public static final int XCPX_STATUS = 5;
    public static final int XMRC_BASE_NETNAME = 6;
    public static final int XMRC_BASE_PU_NAME = 7;
    public static final int XMRC_SHUTDOWN_INPROCESS = 16;
    public static final int XMRC_LULU = 17;
    public static final int XMRC_DOMAIN_NAME = 18;
    public static final int XMRC_FORCE_TO = 19;
    public static final int XMRC_CHGMGT_ENABLED = 21;
    public static final int XMCF_TEMP_AUTO_LOCK = 1013;
    public static final int XMCF_PERM_ACT_AUTO_LOCK = 1014;
    public static final int XMCF_START_UP_STATUS = 1018;
    public static final int XMRC_PHONE_SERVER = 1024;
    public static final int XMRC_RSF_PHONE_NUMBERS = 1030;
    public static final int XMRC_RSF_FILE_DATES = 1031;
    public static final int FIRST_JAVA_SIM_FIELD = 1000;
    public static final int LAST_JAVA_SIM_FIELD = 2000;
    public static final byte XSSE_SE = 1;
    public static final byte XSSE_MC = 2;
    public static final byte XSSE_ALTSE = 3;
    public static final byte XSSE_PHMC = 4;
    private static final SimServer singleton = new SimServer();

    private native byte[] nativeGetSimField(int var1) throws Exception;

    public static SimServer getSimServer() {
        return singleton;
    }

    private static byte[] getSimData(int id) {
        byte[] simdata2;
        switch (id) {
            case 1024: {
                simdata2 = new byte[1];
                if (BaseTower.getBaseTower().isPhoneServer()) {
                    simdata2[0] = 1;
                    break;
                }
                simdata2[0] = 0;
                break;
            }
            case 1018: {
                simdata2 = new byte[1];
                if (BaseTower.getBaseTower().isUpdatingDisabled()) {
                    simdata2[0] = 1;
                    break;
                }
                simdata2[0] = 0;
                break;
            }
            case 1013: {
                simdata2 = new byte[2];
                short count = BaseTower.getBaseTower().getTemporaryFixesActivated();
                simdata2 = BinaryNumber.fromShort(count);
                break;
            }
            case 1014: {
                simdata2 = new byte[2];
                short count = BaseTower.getBaseTower().getPermanentFixesActivated();
                simdata2 = BinaryNumber.fromShort(count);
                break;
            }
            default: {
                byte[] simdata2 = new byte[]{};
                throw new IllegalArgumentException("Sim field not implemented.");
            }
        }
        return simdata2;
    }

    private static void setSimData(int id, byte[] simdata) {
        switch (id) {
            case 1024: {
                boolean value = simdata[0] != 0;
                BaseTower.getBaseTower().setPhoneServer(value);
                break;
            }
            case 1018: {
                boolean value = 1 == (simdata[0] & 1);
                BaseTower.getBaseTower().setUpdatingDisabled(value);
                break;
            }
            case 1013: {
                short count = BinaryNumber.toShort(simdata);
                BaseTower.getBaseTower().setTemporaryFixesActivated(count);
                break;
            }
            case 1014: {
                short count = BinaryNumber.toShort(simdata);
                BaseTower.getBaseTower().setPermanentFixesActivated(count);
                break;
            }
            default: {
                throw new IllegalArgumentException("Sim field not implemented.");
            }
        }
    }

    public byte[] readSim(int id) throws HException {
        Trace.trace(TRACE_MASKT, "-> SimServer.readSim");
        byte[] byteData = null;
        try {
            Trace.trace(TRACE_MASKF, "SimField id = " + id);
            byteData = id < 1000 || id >= 2000 ? this.nativeGetSimField(id) : SimServer.getSimData(id);
            Trace.trace(TRACE_MASKF, "Back from reading SimField()");
            if (byteData == null) {
                Trace.trace(TRACE_MASKF, "byteData is null");
            } else {
                Trace.trace(TRACE_MASKF, "byteData = " + HexString.toHex(byteData));
            }
        }
        catch (IllegalArgumentException exc) {
            Trace.trace(TRACE_MASKF, "Catch and throw IllegalArgumentException.");
            throw exc;
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, "Caught Exception in SimServer.readSim()");
            Trace.trace(TRACE_MASKF, exc);
            throw new HException(exc);
        }
        Trace.trace(TRACE_MASKT, "<- SimServer.readSim");
        return byteData;
    }

    private native void nativeSetSimField(int var1, byte[] var2) throws Exception;

    public void writeSim(int id, byte[] data) throws HException {
        Trace.trace(TRACE_MASKT, "-> SimServer.writeSim");
        try {
            Trace.trace(TRACE_MASKF, "SimField id = " + id);
            if (id < 1000 || id >= 2000) {
                this.nativeSetSimField(id, data);
            } else {
                SimServer.setSimData(id, data);
            }
            Trace.trace(TRACE_MASKF, "Back from setting SimField()");
        }
        catch (IllegalArgumentException e) {
            Trace.trace(TRACE_MASKF, "Catch and throw IllegalArgumentException.");
            throw e;
        }
        catch (Throwable e) {
            Trace.trace(TRACE_MASKF, "Caught exception in SimServer.writeSim()");
            Trace.trace(TRACE_MASKF, e);
            throw new HException(e);
        }
        Trace.trace(TRACE_MASKT, "<- SimServer.writeSim");
    }

    static {
        try {
            System.loadLibrary("jniSimDebug");
            Trace.trace(TRACE_MASKT, "jniSimDebug loaded ok. ");
        }
        catch (Throwable e) {
            Trace.trace(TRACE_MASKT, "Unable to load jniSimDebug library. ");
            Trace.trace(TRACE_MASKT, e);
        }
    }

    public static final class Init
    implements Runnable {
        public void run() {
            block2: {
                try {
                    SimServer.getSimServer().writeSim(16, new byte[]{0});
                }
                catch (Exception e) {
                    if (!CommonSystem.getCommonSystem().isLinux()) break block2;
                    throw new UndeclaredThrowableException(e);
                }
            }
        }
    }
}

